
CREATE OR REPLACE VIEW public.v_pdv_menu_fiscal_movimento_ecf_dados_reducaoz
AS SELECT mp.cd_emp,
    mp.cd_filial,
    mp.cd_cx,
    mp.dt_ecf,
    mp.cont_red_z,
    mp.coo_reducao_z,
    mp.cont_reinicio_op,
    mp.dt_cad,
    mp.hr_cad,
    mp.vlr_vend_bruta,
    mp.vlr_gt_fin,
    mp.vlr_base_icms_subs,
    mp.vlr_isentas,
    mp.vlr_n_trib,
    mp.vlr_desc,
    mp.vlr_canc,
    mp.dt_usuario_ecf,
    mp.dt_usuario_software_basico,
    mp.letra_mf_adicional,
    mp.nr_serie_imp,
    ( SELECT pdv_cx.modelo_ecf
           FROM pdv_cx
          WHERE mp.cd_emp = pdv_cx.cd_emp AND mp.cd_filial = pdv_cx.cd_filial AND mp.cd_cx = pdv_cx.cd_cx) AS modelo_ecf,
        CASE
            WHEN COALESCE(mp.reg_alterado, 0) = 1 THEN 1
            ELSE 0
        END AS reg_alterado
   FROM pdv_mapa_resumo mp;


-- Permissions

ALTER TABLE public.v_pdv_menu_fiscal_movimento_ecf_dados_reducaoz OWNER TO postgres;
GRANT ALL ON TABLE public.v_pdv_menu_fiscal_movimento_ecf_dados_reducaoz TO postgres;